/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.named.PIDType;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PIDEditor
extends Widget {
    public static final DataType[] TYPES = new DataType[]{PIDType.get()};
    private NetworkTable table;
    private JTextField pField;
    private JTextField iField;
    private JTextField dField;
    private JTextField sField;
    private JCheckBox eBox;
    private JLabel pLabel;
    private JLabel iLabel;
    private JLabel dLabel;
    private JLabel sLabel;
    private JLabel eLabel;
    private Double pValue;
    private Double iValue;
    private Double dValue;
    private Double sValue;
    private Boolean eValue;
    private NetworkListener listener = new NetworkListener(){

        public void valueChanged(String key, Object value) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PIDEditor.this.pValue = PIDEditor.this.table.getDouble("p");
                    PIDEditor.this.iValue = PIDEditor.this.table.getDouble("i");
                    PIDEditor.this.dValue = PIDEditor.this.table.getDouble("d");
                    PIDEditor.this.sValue = PIDEditor.this.table.getDouble("setpoint");
                    PIDEditor.this.eValue = PIDEditor.this.table.getBoolean("enabled");
                    PIDEditor.this.pField.setText(PIDEditor.this.pValue.toString());
                    PIDEditor.this.iField.setText(PIDEditor.this.iValue.toString());
                    PIDEditor.this.dField.setText(PIDEditor.this.dValue.toString());
                    PIDEditor.this.sField.setText(PIDEditor.this.sValue.toString());
                    PIDEditor.this.eBox.setSelected(PIDEditor.this.eValue);
                }
            });
        }

        public void valueConfirmed(String key, Object value) {
        }
    };

    public void setValue(Object value) {
        if (this.table != null) {
            this.table.removeListenerFromAll(this.listener);
        }
        this.table = (NetworkTable)value;
        this.table.addListenerToAll(this.listener);
        this.listener.valueChanged(null, null);
    }

    public void init() {
        this.pValue = 0.0;
        this.iValue = 0.0;
        this.dValue = 0.0;
        this.sValue = 0.0;
        this.eValue = false;
        this.setLayout(new PIDLayout());
        this.pLabel = new JLabel("P:");
        this.iLabel = new JLabel("I:");
        this.dLabel = new JLabel("D:");
        this.sLabel = new JLabel("Setpoint:");
        this.eLabel = new JLabel("Enabled:");
        this.pLabel.setHorizontalAlignment(4);
        this.iLabel.setHorizontalAlignment(4);
        this.dLabel.setHorizontalAlignment(4);
        this.sLabel.setHorizontalAlignment(4);
        this.eLabel.setHorizontalAlignment(4);
        this.pField = new JTextField(this.pValue.toString());
        this.pField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Double.parseDouble(PIDEditor.this.pField.getText());
                    if (value != PIDEditor.this.pValue) {
                        PIDEditor.this.table.putDouble("p", value);
                        PIDEditor.this.pValue = value;
                    }
                    PIDEditor.this.requestFocus();
                }
                catch (NumberFormatException ex) {
                    PIDEditor.this.pField.setText(PIDEditor.this.pValue.toString());
                }
            }
        });
        this.iField = new JTextField(this.iValue.toString());
        this.iField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Double.parseDouble(PIDEditor.this.iField.getText());
                    if (value != PIDEditor.this.iValue) {
                        PIDEditor.this.table.putDouble("i", value);
                        PIDEditor.this.iValue = value;
                    }
                    PIDEditor.this.requestFocus();
                }
                catch (NumberFormatException ex) {
                    PIDEditor.this.iField.setText(PIDEditor.this.iValue.toString());
                }
            }
        });
        this.dField = new JTextField(this.dValue.toString());
        this.dField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Double.parseDouble(PIDEditor.this.dField.getText());
                    if (value != PIDEditor.this.dValue) {
                        PIDEditor.this.table.putDouble("d", value);
                        PIDEditor.this.dValue = value;
                    }
                    PIDEditor.this.requestFocus();
                }
                catch (NumberFormatException ex) {
                    PIDEditor.this.dField.setText(PIDEditor.this.dValue.toString());
                }
            }
        });
        this.sField = new JTextField(this.sValue.toString());
        this.sField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Double.parseDouble(PIDEditor.this.sField.getText());
                    if (value != PIDEditor.this.sValue) {
                        PIDEditor.this.table.putDouble("setpoint", value);
                        PIDEditor.this.sValue = value;
                    }
                    PIDEditor.this.requestFocus();
                }
                catch (NumberFormatException ex) {
                    PIDEditor.this.sField.setText(PIDEditor.this.sValue.toString());
                }
            }
        });
        this.eBox = new JCheckBox();
        this.eBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean value = PIDEditor.this.eBox.isSelected();
                if (value != PIDEditor.this.eValue) {
                    // empty if block
                }
                PIDEditor.this.table.putBoolean("enabled", value);
                PIDEditor.this.eValue = value;
                PIDEditor.this.pField.setEnabled(!value);
                PIDEditor.this.iField.setEnabled(!value);
                PIDEditor.this.dField.setEnabled(!value);
            }
        });
        this.eBox.setSelected(this.eValue);
        int columns = 10;
        this.pField.setColumns(columns);
        this.iField.setColumns(columns);
        this.dField.setColumns(columns);
        this.sField.setColumns(columns);
        this.add(this.pLabel);
        this.add(this.iLabel);
        this.add(this.dLabel);
        this.add(this.sLabel);
        this.add(this.eLabel);
        this.add(this.pField);
        this.add(this.iField);
        this.add(this.dField);
        this.add(this.sField);
        this.add(this.eBox);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height));
        this.revalidate();
        this.repaint();
    }

    public void propertyChanged(Property property) {
    }

    private class PIDLayout
    implements LayoutManager {
        private PIDLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            int width = ((PIDEditor)PIDEditor.this).eLabel.getPreferredSize().width + ((PIDEditor)PIDEditor.this).sField.getPreferredSize().width;
            int height = 5 * Math.max(((PIDEditor)PIDEditor.this).sLabel.getPreferredSize().height, ((PIDEditor)PIDEditor.this).sField.getPreferredSize().height);
            return new Dimension(width, height);
        }

        public Dimension minimumLayoutSize(Container parent) {
            int width = ((PIDEditor)PIDEditor.this).eLabel.getMinimumSize().width + Math.max(((PIDEditor)PIDEditor.this).sField.getMinimumSize().width, ((PIDEditor)PIDEditor.this).eBox.getMinimumSize().width);
            int height = 5 * Math.max(((PIDEditor)PIDEditor.this).sLabel.getMinimumSize().height, ((PIDEditor)PIDEditor.this).sField.getMinimumSize().height);
            return new Dimension(width, height);
        }

        public void layoutContainer(Container parent) {
            int height = Math.max(((PIDEditor)PIDEditor.this).eLabel.getPreferredSize().height, ((PIDEditor)PIDEditor.this).sField.getPreferredSize().height);
            int labelWidth = ((PIDEditor)PIDEditor.this).eLabel.getPreferredSize().width;
            int fieldWidth = PIDEditor.this.getWidth() - labelWidth;
            JLabel[] labels = new JLabel[]{PIDEditor.this.pLabel, PIDEditor.this.iLabel, PIDEditor.this.dLabel, PIDEditor.this.sLabel, PIDEditor.this.eLabel};
            for (int i = 0; i < labels.length; ++i) {
                JLabel label = labels[i];
                label.setSize(labelWidth, height);
                label.setLocation(0, i * height);
            }
            JTextField[] fields = new JTextField[]{PIDEditor.this.pField, PIDEditor.this.iField, PIDEditor.this.dField, PIDEditor.this.sField};
            for (int i = 0; i < fields.length; ++i) {
                JTextField field = fields[i];
                field.setSize(fieldWidth, height);
                field.setLocation(labelWidth, i * height);
            }
            PIDEditor.this.eBox.setSize(((PIDEditor)PIDEditor.this).eBox.getPreferredSize().width, height);
            PIDEditor.this.eBox.setLocation(labelWidth, 4 * height);
        }
    }
}

