/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.DashboardFrame;
import edu.wpi.first.smartdashboard.gui.StaticWidget;
import edu.wpi.first.smartdashboard.properties.BooleanProperty;
import edu.wpi.first.smartdashboard.properties.FileProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class Image
extends StaticWidget {
    public final FileProperty img = new FileProperty(this, "Image File");
    public final BooleanProperty aspectKept = new BooleanProperty((PropertyHolder)this, "Maintain Aspect Ratio", false);
    private BufferedImage image;

    public Image() {
        this.setObstruction(false);
    }

    public void init() {
        this.update(this.img, ".");
        this.img.addExtensionFilter("JPEG", ".jpg");
        this.img.addExtensionFilter("GIF", ".gif");
        this.img.addExtensionFilter("PNG", ".png");
        this.img.addExtensionFilter("Bitmap", ".bmp");
        this.img.addExtensionFilter("JPEG", ".jpeg");
        if (this.image == null) {
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public void propertyChanged(Property property) {
        if (property == this.img) {
            try {
                this.image = ImageIO.read(new File((String)this.img.getValue()));
                this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
            }
            catch (IOException e) {
                this.image = null;
                JOptionPane.showMessageDialog(DashboardFrame.getInstance(), "Invalid File Type.", "Input Error", 2);
                this.setPreferredSize(new Dimension(100, 100));
            }
            this.revalidate();
            this.repaint();
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.image == null) {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (((Boolean)this.aspectKept.getValue()).booleanValue()) {
            int width = this.getBounds().width;
            int height = this.getBounds().height;
            double scale = Math.min((double)width / (double)this.image.getWidth(), (double)height / (double)this.image.getHeight());
            g.drawImage(this.image, (int)((double)width - scale * (double)this.image.getWidth()) / 2, (int)((double)height - scale * (double)this.image.getHeight()) / 2, (int)(((double)width + scale * (double)this.image.getWidth()) / 2.0), (int)((double)height + scale * (double)this.image.getHeight()) / 2, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        } else {
            g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        }
    }
}

