/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.ColorProperty;
import edu.wpi.first.smartdashboard.properties.IntegerProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.types.DataType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;

public class FormattedField
extends Widget {
    public static final DataType[] TYPES = new DataType[]{DataType.BASIC};
    public final ColorProperty foreground = new ColorProperty(this, "Foreground");
    public final ColorProperty background = new ColorProperty(this, "Background");
    public final IntegerProperty fontSize = new IntegerProperty((PropertyHolder)this, "Font Size", 12);
    protected JFormattedTextField valueField;

    public void init() {
        this.setLayout(new BorderLayout());
        JLabel nameLabel = new JLabel(this.getFieldName());
        this.valueField = new JFormattedTextField();
        this.update(this.foreground, this.valueField.getForeground());
        this.update(this.background, this.valueField.getBackground());
        this.update(this.fontSize, this.valueField.getFont().getSize());
        this.valueField.setEditable(false);
        this.valueField.setColumns(10);
        this.add((Component)nameLabel, "Before");
        this.add((Component)this.valueField, "Center");
        this.revalidate();
        this.repaint();
    }

    public void setValue(Object value) {
        this.valueField.setValue(value);
        this.revalidate();
        this.repaint();
    }

    public void propertyChanged(Property property) {
        if (property == this.foreground) {
            this.valueField.setForeground((Color)this.foreground.getValue());
        } else if (property == this.background) {
            this.valueField.setBackground((Color)this.background.getValue());
        } else if (property == this.fontSize) {
            this.valueField.setFont(new Font(this.valueField.getFont().getName(), this.valueField.getFont().getStyle(), this.fontSize.getValue()));
        }
    }
}

