/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.StaticWidget;
import edu.wpi.first.smartdashboard.properties.ColorProperty;
import edu.wpi.first.smartdashboard.properties.MultiProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.robot.Robot;
import edu.wpi.first.wpilibj.networking.NetworkConnectionListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.SwingUtilities;

public class ConnectionIndicator
extends StaticWidget
implements NetworkConnectionListener {
    public static final String NAME = "Connection Indicator";
    private static final int DRAW_EMBOSSED = 0;
    private static final int DRAW_ENGRAVED = 1;
    private static final int DRAW_ROUNDED = 2;
    private static final int DRAW_PLAIN = 3;
    public final ColorProperty positive = new ColorProperty((PropertyHolder)this, "Connection Color", Color.GREEN);
    public final ColorProperty negative = new ColorProperty((PropertyHolder)this, "No Connection Color", Color.RED);
    public final MultiProperty display = new MultiProperty(this, "Graphics");
    private boolean firstRun = true;
    private boolean connected = false;
    private Runnable repainter = new Runnable(){

        public void run() {
            ConnectionIndicator.this.repaint();
        }
    };

    public ConnectionIndicator() {
        this.setPreferredSize(new Dimension(32, 32));
        this.display.add("Embossed", 0);
        this.display.add("Engraved", 1);
        this.display.add("Rounded", 2);
        this.display.add("Simple", 3);
        this.display.setDefault("Embossed");
    }

    public void init() {
        Robot.getTable().addConnectionListener((NetworkConnectionListener)this, true);
    }

    public void disconnect() {
        Robot.getTable().removeConnectionListener((NetworkConnectionListener)this);
    }

    public void propertyChanged(Property property) {
        if (property == this.positive && this.connected) {
            this.repaint();
        } else if (property == this.negative && !this.connected) {
            this.repaint();
        } else if (property == this.display) {
            this.repaint();
        }
    }

    protected void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        switch ((Integer)this.display.getValue()) {
            case 0: {
                g.setColor(this.connected ? (Color)this.positive.getValue() : (Color)this.negative.getValue());
                g.fill3DRect(0, 0, size.width, size.height, true);
                break;
            }
            case 1: {
                g.setColor(this.connected ? (Color)this.positive.getValue() : (Color)this.negative.getValue());
                g.fill3DRect(0, 0, size.width, size.height, false);
                break;
            }
            case 2: {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, size.width, size.height);
                g.setColor(this.connected ? (Color)this.positive.getValue() : (Color)this.negative.getValue());
                g.fillRoundRect(0, 0, size.width, size.height, 8, 8);
                break;
            }
            default: {
                g.setColor(this.connected ? (Color)this.positive.getValue() : (Color)this.negative.getValue());
                g.fillRect(0, 0, size.width, size.height);
            }
        }
    }

    public void connected() {
        if (!this.connected) {
            this.connected = true;
            if (!this.firstRun) {
                SwingUtilities.invokeLater(this.repainter);
            }
        }
        this.firstRun = false;
    }

    public void disconnected() {
        if (this.connected) {
            this.connected = false;
            if (!this.firstRun) {
                SwingUtilities.invokeLater(this.repainter);
            }
        }
        this.firstRun = false;
    }
}

