/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.ColorProperty;
import edu.wpi.first.smartdashboard.properties.DoubleProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.named.GyroType;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;

public class Compass
extends Widget
implements NetworkListener {
    public static final DataType[] TYPES = new DataType[]{DataType.NUMBER, GyroType.get()};
    public final DoubleProperty circumference = new DoubleProperty((PropertyHolder)this, "Circumference", 360.0);
    public final ColorProperty ringColor = new ColorProperty((PropertyHolder)this, "Ring Color", Color.YELLOW);
    private JPanel chartPanel;
    private DefaultValueDataset data = new DefaultValueDataset(0.0);
    private CompassPlot m_compass;
    private NetworkTable gyroTable;
    private Runnable updater = new Runnable(){

        public void run() {
            if (Compass.this.gyroTable != null) {
                Compass.this.data.setValue((Number)((double)Compass.this.gyroTable.getInt("angle") + Compass.this.m_compass.getRevolutionDistance() / 2.0));
            }
            Compass.this.repaint();
        }
    };

    public void init() {
        this.setLayout(new BorderLayout());
        this.m_compass = new CompassPlot((ValueDataset)this.data);
        this.m_compass.setSeriesNeedle(7);
        this.m_compass.setSeriesPaint(0, (Paint)Color.RED);
        this.m_compass.setSeriesOutlinePaint(0, (Paint)Color.RED);
        JFreeChart chart = new JFreeChart(this.getFieldName(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.m_compass, false);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setPreferredSize(new Dimension(250, 150));
        this.add((Component)this.chartPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    public void updateDisplay(double value) {
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (this.gyroTable != null) {
            this.gyroTable.removeListener("angle", (NetworkListener)this);
            this.gyroTable = null;
        }
        if (this.getType().isChildOf(DataType.NUMBER)) {
            this.data.setValue((Number)(((Number)value).doubleValue() + this.m_compass.getRevolutionDistance() / 2.0));
        } else if (this.getType().isChildOf(GyroType.get())) {
            this.gyroTable = (NetworkTable)value;
            this.gyroTable.addListener("angle", (NetworkListener)this);
            this.data.setValue((Number)((double)this.gyroTable.getInt("angle") + this.m_compass.getRevolutionDistance() / 2.0));
        }
        this.repaint();
    }

    public void propertyChanged(Property property) {
        if (property == this.circumference) {
            double compassUncorrectedValue = this.data.getValue().doubleValue() - this.m_compass.getRevolutionDistance() / 2.0;
            this.m_compass.setRevolutionDistance(this.circumference.getValue().doubleValue());
            this.updateDisplay(compassUncorrectedValue);
        } else if (property == this.ringColor) {
            this.m_compass.setRosePaint((Paint)this.ringColor.getValue());
        }
    }

    public void valueChanged(String key, Object value) {
        SwingUtilities.invokeLater(this.updater);
    }

    public void valueConfirmed(String key, Object value) {
    }
}

