/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.elements.EditableDisplayElement;
import edu.wpi.first.smartdashboard.properties.BooleanProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.named.StringChooserType;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class Chooser
extends EditableDisplayElement
implements NetworkListener {
    private static final String DEFAULT = "default";
    private static final String COUNT = "count";
    private static final String SELECTED = "selected";
    public static final DataType[] TYPES = new DataType[]{StringChooserType.get()};
    public final BooleanProperty useRadioButtons = new BooleanProperty((PropertyHolder)this, "Use Radio Buttons", true);
    private NetworkTable table;
    private Display display;
    private String selection;

    public void init() {
        this.setResizable(false);
    }

    public void setValue(Object value) {
        if (this.table != null) {
            this.table.removeListenerFromAll((NetworkListener)this);
        }
        this.selection = null;
        this.table = (NetworkTable)value;
        if (this.display != null) {
            this.remove(this.display.panel);
        }
        this.display = (Boolean)this.useRadioButtons.getValue() != false ? new RadioButtons() : new ComboBox();
        this.display.setValue(this.table);
        this.table.addListenerToAll((NetworkListener)this);
    }

    public void valueChanged(String key, Object value) {
        if (key.equals(COUNT)) {
            this.display.setValue(this.table);
        } else if (key.equals(DEFAULT) && this.selection == null) {
            this.display.setValue(this.table);
        } else if (key.equals(SELECTED)) {
            this.display.setSelected((String)value);
        }
    }

    public void valueConfirmed(String key, Object value) {
        this.valueChanged(key, value);
    }

    public void propertyChanged(Property property) {
        if (property == this.useRadioButtons) {
            this.setValue(this.table);
        } else if (property == this.editable) {
            this.display.setEditable((Boolean)this.editable.getValue());
        }
    }

    private class ComboBox
    extends Display
    implements ItemListener {
        JComboBox combo;

        private ComboBox() {
        }

        void setEditable(boolean editable) {
            if (this.combo != null) {
                this.combo.setEnabled(editable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setValue(NetworkTable table) {
            if (this.combo != null) {
                this.panel.remove(this.combo);
                this.combo.removeItemListener(this);
            }
            this.combo = new JComboBox();
            NetworkTable networkTable = table;
            synchronized (networkTable) {
                int values = table.getInt(Chooser.COUNT);
                boolean hasSelection = false;
                for (int i = 0; i < values; ++i) {
                    String choice = table.getString(String.valueOf(i));
                    hasSelection |= choice.equals(Chooser.this.selection);
                    this.combo.addItem(choice);
                }
                if (!hasSelection) {
                    Chooser.this.selection = null;
                }
                if (table.containsKey(Chooser.SELECTED)) {
                    Chooser.this.selection = table.getString(Chooser.SELECTED);
                }
                if (Chooser.this.selection != null) {
                    this.combo.setSelectedItem(Chooser.this.selection);
                    table.putString(Chooser.SELECTED, Chooser.this.selection);
                } else if (table.containsKey(Chooser.DEFAULT)) {
                    this.combo.setSelectedItem(table.getString(Chooser.DEFAULT));
                }
            }
            this.panel.add(this.combo);
            this.combo.addItemListener(this);
            this.combo.setEnabled((Boolean)Chooser.this.editable.getValue());
            Chooser.this.revalidate();
            Chooser.this.repaint();
            Chooser.this.setSize(Chooser.this.getPreferredSize());
        }

        void setSelected(String selected) {
            if (this.combo != null) {
                this.combo.setSelectedItem(selected);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            String userChoice;
            if (e.getStateChange() == 1 && !(userChoice = (String)e.getItem()).equals(Chooser.this.selection)) {
                Chooser.this.selection = userChoice;
                Chooser.this.table.putString(Chooser.SELECTED, Chooser.this.selection);
            }
        }
    }

    private class RadioButtons
    extends Display
    implements ActionListener {
        JPanel groupPanel;
        ButtonGroup group;
        JRadioButton selected;
        Map<String, JRadioButton> buttons;

        private RadioButtons() {
        }

        void setEditable(boolean editable) {
            for (JRadioButton button : this.buttons.values()) {
                button.setEnabled(editable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setValue(NetworkTable table) {
            if (this.groupPanel != null) {
                this.panel.remove(this.groupPanel);
                for (JRadioButton button : this.buttons.values()) {
                    this.group.remove(button);
                }
                this.buttons.clear();
            }
            this.groupPanel = new JPanel();
            this.groupPanel.setOpaque(false);
            this.groupPanel.setLayout(new BoxLayout(this.groupPanel, 1));
            this.group = new ButtonGroup();
            this.buttons = new HashMap<String, JRadioButton>();
            NetworkTable networkTable = table;
            synchronized (networkTable) {
                int values = table.getInt(Chooser.COUNT);
                boolean hasSelection = false;
                for (int i = 0; i < values; ++i) {
                    String choice = table.getString(String.valueOf(i));
                    hasSelection |= choice.equals(Chooser.this.selection);
                    JRadioButton button = new JRadioButton(choice);
                    this.buttons.put(choice, button);
                    this.group.add(button);
                    this.groupPanel.add(button);
                    button.setActionCommand(choice);
                    button.addActionListener(this);
                }
                if (!hasSelection) {
                    Chooser.this.selection = null;
                }
                if (table.containsKey(Chooser.SELECTED)) {
                    Chooser.this.selection = table.getString(Chooser.SELECTED);
                }
                if (Chooser.this.selection != null) {
                    table.putString(Chooser.SELECTED, Chooser.this.selection);
                    this.selected = this.buttons.get(Chooser.this.selection);
                    this.selected.setSelected(true);
                } else if (table.containsKey(Chooser.DEFAULT)) {
                    this.selected = this.buttons.get(table.getString(Chooser.DEFAULT));
                    this.selected.setSelected(true);
                } else {
                    this.selected = null;
                }
            }
            Chooser.this.setEnabled((Boolean)Chooser.this.editable.getValue());
            this.panel.add(this.groupPanel);
            Chooser.this.revalidate();
            Chooser.this.repaint();
            Chooser.this.setSize(Chooser.this.getPreferredSize());
        }

        void setSelected(String selected) {
            this.buttons.get(selected).setSelected(true);
        }

        public void actionPerformed(ActionEvent e) {
            String userChoice = e.getActionCommand();
            if (Chooser.this.selection == null || !Chooser.this.selection.equals(userChoice)) {
                Chooser.this.selection = userChoice;
                Chooser.this.table.putString(Chooser.SELECTED, Chooser.this.selection);
            }
        }
    }

    private abstract class Display {
        JPanel panel = new JPanel();

        public Display() {
            this.panel.setOpaque(false);
            Chooser.this.add(this.panel);
        }

        abstract void setEditable(boolean var1);

        abstract void setValue(NetworkTable var1);

        abstract void setSelected(String var1);
    }
}

