/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.elements.EditableDisplayElement;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.robot.Robot;
import edu.wpi.first.smartdashboard.types.DataType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;

public class CheckBox
extends EditableDisplayElement
implements ActionListener {
    public static final DataType[] TYPES = new DataType[]{DataType.BOOLEAN};
    private JCheckBox valueField;
    private boolean value;

    public void init() {
        this.setResizable(false);
        this.setLayout(new BoxLayout(this, 0));
        this.valueField = new JCheckBox(this.getFieldName());
        this.valueField.addActionListener(this);
        this.add(this.valueField);
    }

    public void setValue(Object value) {
        this.value = (Boolean)value;
        this.valueField.setSelected(this.value);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.value ^ this.valueField.isSelected()) {
            this.value = !this.value;
            Robot.getTable().putBoolean(this.getFieldName(), this.value);
        }
    }

    public void propertyChanged(Property property) {
        if (property == this.editable) {
            this.valueField.setEnabled((Boolean)this.editable.getValue());
        }
    }
}

