/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.ColorProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.types.DataType;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BooleanBox
extends Widget {
    public static final DataType[] TYPES = new DataType[]{DataType.BOOLEAN};
    public final ColorProperty colorOnTrue = new ColorProperty((PropertyHolder)this, "Color to show when true", Color.GREEN);
    public final ColorProperty colorOnFalse = new ColorProperty((PropertyHolder)this, "Color to show when false", Color.RED);
    private JPanel valueField;
    private boolean value;

    public void init() {
        this.setLayout(new BoxLayout(this, 0));
        JLabel nameLabel = new JLabel(this.getFieldName());
        this.valueField = new JPanel();
        this.valueField.setPreferredSize(new Dimension(10, 10));
        this.add(this.valueField);
        this.add(nameLabel);
        this.revalidate();
        this.repaint();
    }

    public void setValue(Object value) {
        this.value = (Boolean)value;
        this.valueField.setBackground(this.value ? (Color)this.colorOnTrue.getValue() : (Color)this.colorOnFalse.getValue());
        this.repaint();
    }

    public void propertyChanged(Property property) {
        if (property == this.colorOnTrue && this.value) {
            this.valueField.setBackground((Color)this.colorOnTrue.getValue());
        } else if (property == this.colorOnFalse && !this.value) {
            this.valueField.setBackground((Color)this.colorOnFalse.getValue());
        }
    }
}

