/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui;

import edu.wpi.first.smartdashboard.LogToCSV;
import edu.wpi.first.smartdashboard.gui.DashboardFrame;
import edu.wpi.first.smartdashboard.properties.BooleanProperty;
import edu.wpi.first.smartdashboard.properties.FileProperty;
import edu.wpi.first.smartdashboard.properties.IntegerListProperty;
import edu.wpi.first.smartdashboard.properties.IntegerProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardPrefs
implements PropertyHolder {
    private static DashboardPrefs instance = null;
    private Map<String, Property> properties = new LinkedHashMap<String, Property>();
    public final IntegerProperty team = new IntegerProperty((PropertyHolder)this, "Team Number", 190);
    public final BooleanProperty hideMenu = new BooleanProperty((PropertyHolder)this, "Hide Menu", false);
    public final BooleanProperty autoShowWidgets = new BooleanProperty((PropertyHolder)this, "Automatically Show Widgets", true);
    public final IntegerListProperty grid_widths = new IntegerListProperty((PropertyHolder)this, "Grid Cell Width(s)", new int[]{16});
    public final IntegerListProperty grid_heights = new IntegerListProperty((PropertyHolder)this, "Grid Cell Height(s)", new int[]{16});
    public final IntegerProperty x = new IntegerProperty((PropertyHolder)this, "Window X Position", 0);
    public final IntegerProperty y = new IntegerProperty((PropertyHolder)this, "Window Y Position", 0);
    public final IntegerProperty width = new IntegerProperty((PropertyHolder)this, "Window Width", 640);
    public final IntegerProperty height = new IntegerProperty((PropertyHolder)this, "Window Height", 480);
    public final FileProperty saveFile = new FileProperty((PropertyHolder)this, "Save File", "./save.xml");
    public final BooleanProperty logToCSV = new BooleanProperty((PropertyHolder)this, "Log to CSV", false);
    public final FileProperty csvFile = new FileProperty((PropertyHolder)this, "CSV File", "./csv.txt");
    private Preferences node = Preferences.userNodeForPackage(this.getClass());

    public static DashboardPrefs getInstance() {
        if (instance == null) {
            instance = new DashboardPrefs();
        }
        return instance;
    }

    private DashboardPrefs() {
        for (Property property : this.properties.values()) {
            if (property == this.logToCSV) continue;
            this.load(property);
        }
    }

    private void load(Property property) {
        property.setSaveValue(this.node.get(property.getName(), property.getSaveValue()));
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean validatePropertyChange(Property property, Object value) {
        if (property == this.team || property == this.width || property == this.height) {
            return (Integer)value > 0;
        }
        if (property == this.grid_widths || property == this.grid_heights) {
            int[] values = (int[])value;
            if (values.length == 0) {
                return false;
            }
            for (int i : values) {
                if (i > 0) continue;
                return false;
            }
            return true;
        }
        if (property == this.logToCSV && ((Boolean)value).booleanValue()) {
            int result = JOptionPane.showOptionDialog(null, "Should SmartDashboard start logging to the CSV file? (This will override the existing file)", "Warning", 0, 2, null, null, false);
            return result == 0;
        }
        return true;
    }

    @Override
    public void propertyChanged(Property property) {
        this.node.put(property.getName(), property.getSaveValue());
        DashboardFrame frame = DashboardFrame.getInstance();
        if (property == this.x) {
            frame.setLocation(this.x.getValue(), frame.getY());
        } else if (property == this.y) {
            frame.setLocation(frame.getX(), this.y.getValue());
        } else if (property == this.width) {
            frame.setSize(this.width.getValue(), frame.getHeight());
        } else if (property == this.height) {
            frame.setSize(frame.getWidth(), this.height.getValue());
        } else if (property == this.team) {
            NetworkTable.setTeam((int)this.team.getValue());
            DashboardFrame.getInstance().setTitle("SmartDashboard - " + this.team.getValue());
        } else if (property == this.hideMenu) {
            DashboardFrame.getInstance().setShouldHideMenu((Boolean)this.hideMenu.getValue());
        } else if (property == this.logToCSV) {
            if (((Boolean)this.logToCSV.getValue()).booleanValue()) {
                LogToCSV.getInstance().start((String)this.csvFile.getValue());
            } else {
                LogToCSV.getInstance().stop();
            }
        }
    }
}

