/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui;

import edu.wpi.first.smartdashboard.gui.DashboardPrefs;
import edu.wpi.first.smartdashboard.gui.DisplayElement;
import edu.wpi.first.smartdashboard.gui.GlassPane;
import edu.wpi.first.smartdashboard.gui.StaticWidget;
import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.robot.Robot;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.DisplayElementRegistry;
import edu.wpi.first.smartdashboard.types.NamedDataType;
import edu.wpi.first.wpilibj.networking.NetworkAdditionListener;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardPanel
extends JPanel {
    private GlassPane glassPane = new GlassPane();
    private JPanel backPane = new JPanel();
    private LinkedList<DisplayElement> elements = new LinkedList();
    private Map<String, Widget> fields = new HashMap<String, Widget>();
    private Set<String> hiddenFields = new HashSet<String>();
    private boolean editable = false;
    private RobotListener listener;
    private static final Random random = new Random();

    public DashboardPanel() {
        this.add(this.glassPane);
        this.add(this.backPane);
        this.backPane.setLayout(new DashboardLayout());
        this.backPane.setFocusable(true);
        this.setLayout(new DashboardLayout());
        this.setEditable(this.editable);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.glassPane.addMouseListener(l);
        this.backPane.addMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.glassPane.addMouseMotionListener(l);
        this.backPane.addMouseMotionListener(l);
    }

    public void beginListening() {
        if (this.listener == null) {
            this.listener = new RobotListener();
            Robot.getTable().addAdditionListener((NetworkAdditionListener)this.listener, true);
            Robot.getTable().addListenerToAll((NetworkListener)this.listener);
        }
    }

    public void revalidateBacking() {
        this.backPane.revalidate();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.glassPane.setVisible(editable);
        if (editable) {
            this.glassPane.requestFocus();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Iterable<String> getHiddenFields() {
        return this.hiddenFields;
    }

    public Iterable<DisplayElement> getElements() {
        return this.elements;
    }

    private Object verifyValue(DataType type, Object value) {
        if (type == null || value == null) {
            return null;
        }
        if (type instanceof NamedDataType) {
            return ((NetworkTable)value).getSubTable("Data");
        }
        return value;
    }

    public void clear() {
        this.hiddenFields.clear();
        this.fields.clear();
        for (DisplayElement element : this.elements) {
            element.disconnect();
            this.backPane.remove(element);
        }
        this.elements.clear();
        Robot.getTable().addAdditionListener((NetworkAdditionListener)this.listener, true);
        this.repaint();
    }

    public void removeUnusedFields() {
        ArrayList<String> unused = new ArrayList<String>();
        for (String field : this.fields.keySet()) {
            if (Robot.getTable().containsKey(field)) continue;
            unused.add(field);
        }
        for (String field : unused) {
            this.removeField(field);
            this.hiddenFields.remove(field);
        }
    }

    public void removeField(String field) {
        Widget elem = this.fields.get(field);
        this.hiddenFields.add(field);
        if (elem != null) {
            elem.disconnect();
            this.backPane.remove(elem);
            this.fields.remove(field);
            this.elements.remove(elem);
            this.repaint(elem.getBounds());
        }
    }

    public void removeElement(StaticWidget widget) {
        widget.disconnect();
        this.backPane.remove(widget);
        this.elements.remove(widget);
        this.repaint(widget.getBounds());
    }

    public void shiftToBack(DisplayElement element) {
        int count = 0;
        this.elements.remove(element);
        for (DisplayElement e : this.elements) {
            this.backPane.setComponentZOrder(e, count++);
        }
        this.backPane.setComponentZOrder(element, count);
        this.elements.add(element);
        this.repaint();
    }

    public void addElement(DisplayElement element, Point point) {
        element.init();
        if (point == null) {
            Dimension saved = element.getSavedSize();
            Dimension preferred = element.getPreferredSize();
            if (saved.width > 0) {
                preferred.width = saved.width;
            }
            if (saved.height > 0) {
                preferred.height = saved.height;
            }
            element.setSize(preferred);
            point = this.findSpace(element);
            element.setBounds(new Rectangle(point, preferred));
        }
        element.setSavedLocation(point);
        this.backPane.add(element);
        int count = 1;
        for (DisplayElement e : this.elements) {
            this.backPane.setComponentZOrder(e, count++);
        }
        this.backPane.setComponentZOrder(element, 0);
        this.elements.addFirst(element);
        this.revalidate();
        this.repaint();
    }

    public void setField(String key, Widget element, DataType type, Object value, Point point) {
        this.removeField(key);
        this.hiddenFields.remove(key);
        value = this.verifyValue(type, value);
        element.setFieldName(key);
        if (type != null) {
            element.setType(type);
        }
        this.fields.put(key, element);
        this.addElement(element, point);
        if (value != null) {
            element.setValue(value);
        }
    }

    public void addField(String key) {
        this.setField(key, null, Robot.getTable().containsKey(key) ? Robot.getTable().getValue(key) : null, null);
    }

    public void setField(String key, Class<? extends Widget> preferred, Object value, Point point) {
        this.setField(key, preferred, DataType.getType(value), value, point);
    }

    public void setField(String key, Class<? extends Widget> preferred, DataType type, Object value, Point point) {
        Widget element = this.fields.get(key);
        if (type == null) {
            System.out.println("WARNING: has no way of handling data at field \"" + key + "\"");
            this.removeField(key);
        } else if (element != null && preferred == null && (element.getType() == type || element.supportsType(type))) {
            if (element.getType() != type) {
                element.setType(type);
            }
            if ((value = this.verifyValue(type, value)) != null) {
                element.setValue(value);
            }
        } else {
            Class<Widget> clazz;
            Class<Widget> clazz2 = clazz = preferred == null ? type.getDefault() : preferred;
            if (clazz == null) {
                Set<Class<? extends Widget>> candidates = DisplayElementRegistry.getWidgetsForType(type);
                if (candidates.isEmpty()) {
                    System.out.println("WARNING: has no way of handling type " + type);
                    return;
                }
                clazz = (Class<Widget>)candidates.toArray()[0];
            }
            try {
                element = clazz.newInstance();
                this.setField(key, element, type, value, point);
            }
            catch (InstantiationException ex) {
                System.out.println("ERROR: " + clazz.getName() + " has no default constructor!");
            }
            catch (IllegalAccessException ex) {
                System.out.println("ERROR: " + clazz.getName() + " has no public default constructor!");
            }
        }
    }

    public DisplayElement findElementContaining(Point point) {
        for (DisplayElement element : this.elements) {
            if (!element.getBounds().contains(point)) continue;
            return element;
        }
        return null;
    }

    private Point findSpace(DisplayElement toPlace) {
        Stack<Point> positions = new Stack<Point>();
        positions.add(new Point(0, 0));
        Dimension size = toPlace.getPreferredSize();
        Dimension panelBounds = this.getSize();
        block0: while (!positions.isEmpty()) {
            Point position = (Point)positions.pop();
            Rectangle area = new Rectangle(position, size);
            if (area.x < 0 || area.y < 0 || area.x + area.width > panelBounds.width || area.y + area.height > panelBounds.height) continue;
            for (DisplayElement element : this.elements) {
                if (element == toPlace || !element.isObstruction()) continue;
                Rectangle bounds = element.getBounds();
                if (bounds.x > area.x + area.width || bounds.x + bounds.width < area.x || bounds.y > area.y + area.height || bounds.y + bounds.height < area.y) continue;
                Point right = new Point(bounds.x + bounds.width + 1, position.y);
                if (positions.isEmpty()) {
                    positions.add(right);
                    right = null;
                }
                positions.add(new Point(position.x, bounds.y + bounds.height + 1));
                if (right == null || Math.abs(right.x - area.x) >= area.width / 3) continue block0;
                positions.add(right);
                continue block0;
            }
            return position;
        }
        return new Point(random.nextInt(32), random.nextInt(32));
    }

    private class DashboardLayout
    implements LayoutManager {
        private DashboardLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(640, 480);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public void layoutContainer(Container parent) {
            if (parent == DashboardPanel.this) {
                Dimension size = DashboardPanel.this.getSize();
                DashboardPanel.this.glassPane.setBounds(0, 0, size.width, size.height);
                DashboardPanel.this.backPane.setBounds(0, 0, size.width, size.height);
            } else {
                for (DisplayElement element : DashboardPanel.this.elements) {
                    element.setLocation(element.getSavedLocation());
                    Dimension savedSize = element.getSavedSize();
                    Dimension preferredSize = element.getPreferredSize();
                    Dimension size = new Dimension(preferredSize);
                    if (savedSize != null && savedSize.width != -1) {
                        size.width = savedSize.width;
                    }
                    if (savedSize != null && savedSize.height != -1) {
                        size.height = savedSize.height;
                    }
                    element.setSize(size);
                }
            }
        }
    }

    private class RobotListener
    implements NetworkListener,
    NetworkAdditionListener {
        private RobotListener() {
        }

        public void valueChanged(final String key, final Object value) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!DashboardPanel.this.hiddenFields.contains(key)) {
                        DashboardPanel.this.setField(key, null, value, null);
                    }
                }
            });
        }

        public void valueConfirmed(String key, Object value) {
        }

        public void fieldAdded(String name, Object value) {
            if (((Boolean)DashboardPrefs.getInstance().autoShowWidgets.getValue()).booleanValue() || DashboardPanel.this.fields.containsKey(name)) {
                this.valueChanged(name, value);
            } else {
                DashboardPanel.this.hiddenFields.add(name);
            }
        }
    }
}

