/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui;

import edu.wpi.first.smartdashboard.gui.DashboardMenu;
import edu.wpi.first.smartdashboard.gui.DashboardPanel;
import edu.wpi.first.smartdashboard.gui.DashboardPrefs;
import edu.wpi.first.smartdashboard.gui.DisplayElement;
import edu.wpi.first.smartdashboard.gui.PropertyEditor;
import edu.wpi.first.smartdashboard.gui.StaticWidget;
import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.robot.Robot;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.DisplayElementRegistry;
import edu.wpi.first.smartdashboard.xml.SmartDashboardXMLReader;
import edu.wpi.first.smartdashboard.xml.SmartDashboardXMLWriter;
import edu.wpi.first.smartdashboard.xml.XMLWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

public class DashboardFrame
extends JFrame {
    private static DashboardFrame instance;
    private static final int MENU_HEADER = 10;
    private static final Dimension NETBOOK_SIZE;
    private static final Dimension MINIMUM_SIZE;
    private DashboardPanel panel;
    private JMenuBar menuBar;
    private PropertyEditor propEditor = null;
    private boolean shouldHideMenu;

    public static void initialize(boolean competition) {
        if (instance == null) {
            instance = new DashboardFrame(competition);
        }
    }

    public static DashboardFrame getInstance() {
        DashboardFrame.initialize(false);
        return instance;
    }

    private DashboardFrame(boolean competition) {
        super("SmartDashboard - " + DashboardPrefs.getInstance().team.getValue());
        this.shouldHideMenu = (Boolean)DashboardPrefs.getInstance().hideMenu.getValue();
        this.setLayout(new BorderLayout());
        this.panel = new DashboardPanel();
        this.menuBar = new DashboardMenu(this.panel);
        if (!this.shouldHideMenu) {
            this.add((Component)this.menuBar, "North");
        }
        this.add((Component)this.panel, "Center");
        MouseAdapter hideListener = new MouseAdapter(){

            public void mouseMoved(MouseEvent e) {
                if (DashboardFrame.this.shouldHideMenu && e.getY() < 10) {
                    DashboardFrame.this.add((Component)DashboardFrame.this.menuBar, "North");
                    DashboardFrame.this.validate();
                }
            }

            public void mouseEntered(MouseEvent e) {
                if (DashboardFrame.this.shouldHideMenu) {
                    DashboardFrame.this.remove(DashboardFrame.this.menuBar);
                    DashboardFrame.this.validate();
                }
            }
        };
        this.panel.addMouseListener(hideListener);
        this.panel.addMouseMotionListener(hideListener);
        if (competition) {
            this.setPreferredSize(NETBOOK_SIZE);
            this.setUndecorated(true);
            this.setLocation(0, 0);
            this.setResizable(false);
        } else {
            this.setMinimumSize(MINIMUM_SIZE);
            this.setDefaultCloseOperation(0);
            DashboardPrefs prefs = DashboardPrefs.getInstance();
            this.setPreferredSize(new Dimension(prefs.width.getValue(), prefs.height.getValue()));
            this.setLocation(prefs.x.getValue(), prefs.y.getValue());
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DashboardFrame.this.exit();
            }
        });
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                DashboardPrefs.getInstance().width.setValue(DashboardFrame.this.getWidth());
                DashboardPrefs.getInstance().height.setValue(DashboardFrame.this.getHeight());
            }

            public void componentMoved(ComponentEvent e) {
                DashboardPrefs.getInstance().x.setValue(DashboardFrame.this.getX());
                DashboardPrefs.getInstance().y.setValue(DashboardFrame.this.getY());
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public DashboardPanel getPanel() {
        return this.panel;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.propEditor == null) {
            this.propEditor = new PropertyEditor(this);
        }
        return this.propEditor;
    }

    public void setShouldHideMenu(boolean shouldHide) {
        if (this.shouldHideMenu != shouldHide) {
            this.shouldHideMenu = shouldHide;
            if (this.shouldHideMenu) {
                this.remove(this.menuBar);
            } else {
                this.add((Component)this.menuBar, "North");
            }
            this.validate();
        }
    }

    public void save(String path) {
        try {
            SmartDashboardXMLWriter writer = new SmartDashboardXMLWriter(path);
            for (DisplayElement element : this.panel.getElements()) {
                boolean isWidget = element instanceof Widget;
                assert (isWidget || element instanceof StaticWidget);
                if (isWidget) {
                    writer.beginWidget(((Widget)element).getFieldName(), ((Widget)element).getType().getName(), element.getClass().getName());
                } else {
                    writer.beginStaticWidget(element.getClass().getName());
                }
                writer.addLocation(element.getLocation());
                Dimension size = element.getSavedSize();
                if (size.width > 0) {
                    writer.addWidth(size.width);
                }
                if (size.height > 0) {
                    writer.addHeight(size.height);
                }
                for (Map.Entry<String, Property> prop : element.getProperties().entrySet()) {
                    if (prop.getValue().isDefault()) continue;
                    writer.addProperty(prop.getKey(), prop.getValue().getSaveValue());
                }
                if (isWidget) {
                    writer.endWidget();
                    continue;
                }
                writer.endStaticWidget();
            }
            for (String field : this.panel.getHiddenFields()) {
                writer.addHiddenField(field);
            }
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void load(String path) {
        try {
            SmartDashboardXMLReader reader = new SmartDashboardXMLReader(path);
            List<XMLWidget> widgets = reader.getXMLWidgets();
            for (int i = widgets.size(); i > 0; --i) {
                DisplayElement e;
                XMLWidget widget = widgets.get(i - 1);
                DisplayElement element = widget.convertToDisplayElement();
                if (element instanceof Widget) {
                    e = (Widget)element;
                    Object value = null;
                    if (Robot.getTable().containsKey(((Widget)e).getFieldName())) {
                        value = Robot.getTable().getValue(((Widget)e).getFieldName());
                        DataType type = DataType.getType(value);
                        if (!DisplayElementRegistry.supportsType(e.getClass(), type)) continue;
                        this.panel.setField(((Widget)e).getFieldName(), (Widget)e, type, value, e.getSavedLocation());
                        continue;
                    }
                    this.panel.setField(((Widget)e).getFieldName(), (Widget)e, widget.getType(), null, e.getSavedLocation());
                    continue;
                }
                if (!(element instanceof StaticWidget)) continue;
                e = (StaticWidget)element;
                this.panel.addElement(e, widget.getLocation());
            }
            for (String field : reader.getHiddenFields()) {
                this.panel.removeField(field);
            }
            Map<String, Property> prefs = DashboardPrefs.getInstance().getProperties();
            for (Map.Entry<String, String> entry : reader.getProperties().entrySet()) {
                Property prop = prefs.get(entry.getKey());
                prop.setValue(entry.getValue());
            }
            this.repaint();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void exit() {
        int result = JOptionPane.showConfirmDialog(this, new String[]{"Do you wish to save this layout?"}, "Save before quiting?", 1, 2);
        switch (result) {
            case 0: {
                this.save((String)DashboardPrefs.getInstance().saveFile.getValue());
            }
            case 1: {
                System.exit(0);
            }
        }
    }

    static {
        NETBOOK_SIZE = new Dimension(1024, 400);
        MINIMUM_SIZE = new Dimension(300, 200);
    }
}

