/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.extensions;

import edu.wpi.first.smartdashboard.gui.StaticWidget;
import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.types.DisplayElementRegistry;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.ProgressMonitor;

public class FileSniffer {
    public static void findExtensions(ProgressMonitor monitor, int min, int max) {
        monitor.setNote("Loading Extensions");
        File extensions = new File("./extensions");
        File lib1 = new File("./lib");
        File lib2 = new File("./extensions/lib");
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = null;
        try {
            method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            monitor.setProgress(max);
            return;
        }
        for (File lib : new File[]{lib1, lib2, extensions}) {
            if (!lib.exists()) {
                monitor.setProgress(min + (max - min) / 5);
                continue;
            }
            System.out.println("Searching Folder:" + lib);
            monitor.setNote("Searching Folder:" + lib);
            File[] files = lib.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (files == null) {
                monitor.setProgress(min + (max - min) / 5);
                continue;
            }
            for (File file : files) {
                System.out.println("Adding Jar:" + file);
                try {
                    method.invoke((Object)sysloader, file.toURI().toURL());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            monitor.setProgress(min + (max - min) / 5);
        }
        if (!extensions.exists()) {
            System.out.println("No Extension Folder");
            monitor.setProgress(max);
            return;
        }
        File[] files = extensions.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        double fileCount = 0.0;
        for (File file : files) {
            System.out.println("Searching Jar:" + file);
            double d = fileCount;
            fileCount = d + 1.0;
            monitor.setProgress((int)((double)(min + max) / 2.0 * (1.0 + d / (double)files.length)));
            monitor.setNote("Searching Jar:" + file);
            try {
                JarFile jar = new JarFile(file);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    Class<?> clazz = null;
                    try {
                        name = name.substring(0, name.length() - 6);
                        name = name.replaceAll("/", ".");
                        clazz = Class.forName(name, false, sysloader);
                        Class<Widget> element = clazz.asSubclass(Widget.class);
                        DisplayElementRegistry.registerWidget(element);
                        System.out.println("Custom Widget:" + clazz.getSimpleName());
                    }
                    catch (ClassCastException ex) {
                        try {
                            Class<StaticWidget> element = clazz.asSubclass(StaticWidget.class);
                            DisplayElementRegistry.registerStaticWidget(element);
                            System.out.println("Custom Static Widget:" + clazz.getSimpleName());
                        }
                        catch (ClassCastException ex2) {
                        }
                    }
                    catch (ClassNotFoundException ex) {
                    }
                    catch (NoClassDefFoundError ex) {}
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.out.println("Error, could not add URL to system classloader");
            }
        }
        monitor.setProgress(max);
    }
}

