/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard;

import edu.wpi.first.smartdashboard.gui.DashboardPrefs;
import edu.wpi.first.smartdashboard.robot.Robot;
import edu.wpi.first.wpilibj.networking.NetworkAdditionListener;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;

public class LogToCSV
implements NetworkListener,
NetworkAdditionListener {
    private static final String s_lineSeparator = System.getProperty("line.separator");
    private long m_startTime;
    private FileWriter m_fw;
    private static LogToCSV instance;

    public static LogToCSV getInstance() {
        return instance == null ? (instance = new LogToCSV()) : instance;
    }

    public void start(String path) {
        if (this.m_fw == null) {
            try {
                this.m_startTime = System.currentTimeMillis();
                this.m_fw = new FileWriter(path);
                this.m_fw.write("Time (ms),Name,Value" + s_lineSeparator);
                this.m_fw.flush();
                Robot.getTable().addListenerToAll((NetworkListener)this);
                Robot.getTable().addAdditionListener((NetworkAdditionListener)this, true);
                Robot.getTable().removeAdditionListener((NetworkAdditionListener)this);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(null, "An error occurred when attempting to open the output CSV file for writing. Please check the file path preference.", "Unable to Open CSV File", 0);
                DashboardPrefs.getInstance().logToCSV.setValue(false);
            }
        }
    }

    public void stop() {
        if (this.m_fw == null) {
            return;
        }
        try {
            this.m_fw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Robot.getTable().removeListenerFromAll((NetworkListener)this);
        this.m_fw = null;
    }

    public void valueChanged(String key, Object value) {
        if (!(value instanceof NetworkTable) && this.m_fw != null) {
            try {
                long timeStamp = System.currentTimeMillis() - this.m_startTime;
                this.m_fw.write(timeStamp + "," + "\"" + key + "\"," + "\"" + value + "\"" + s_lineSeparator);
                this.m_fw.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void valueConfirmed(String key, Object value) {
        this.valueChanged(key, value);
    }

    public void fieldAdded(String name, Object value) {
        this.valueChanged(name, value);
    }
}

