/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpijavacv;

import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import edu.wpi.first.wpijavacv.WPIPoint;

public class WPIPolygon {
    opencv_core.CvSeq polygon;
    opencv_core.CvRect boundingRect;

    WPIPolygon(opencv_core.CvSeq data) {
        this.polygon = data;
    }

    opencv_core.CvSeq getCVSeq() {
        return this.polygon;
    }

    public WPIPoint[] getPoints() {
        opencv_core.CvPoint points = new opencv_core.CvPoint(this.getNumVertices());
        WPIPoint[] wpiPoints = new WPIPoint[this.getNumVertices()];
        opencv_core.cvCvtSeqToArray((opencv_core.CvSeq)this.polygon, (Pointer)points.position(0), (opencv_core.CvSlice)opencv_core.CV_WHOLE_SEQ);
        for (int j = 0; j < this.getNumVertices(); ++j) {
            wpiPoints[j] = new WPIPoint(points.position(j).x(), points.position(j).y());
        }
        return wpiPoints;
    }

    public int getWidth() {
        if (this.boundingRect == null) {
            this.boundingRect = opencv_imgproc.cvBoundingRect((opencv_core.CvArr)this.polygon, (int)0);
        }
        return this.boundingRect.width();
    }

    public int getHeight() {
        if (this.boundingRect == null) {
            this.boundingRect = opencv_imgproc.cvBoundingRect((opencv_core.CvArr)this.polygon, (int)0);
        }
        return this.boundingRect.height();
    }

    public int getX() {
        if (this.boundingRect == null) {
            this.boundingRect = opencv_imgproc.cvBoundingRect((opencv_core.CvArr)this.polygon, (int)0);
        }
        return this.boundingRect.x();
    }

    public int getY() {
        if (this.boundingRect == null) {
            this.boundingRect = opencv_imgproc.cvBoundingRect((opencv_core.CvArr)this.polygon, (int)0);
        }
        return this.boundingRect.y();
    }

    public int getNumVertices() {
        return this.polygon.total();
    }

    public boolean isConvex() {
        return opencv_imgproc.cvCheckContourConvexity((opencv_core.CvArr)this.polygon) != 0;
    }

    public int getArea() {
        return Math.abs((int)opencv_imgproc.cvContourArea((opencv_core.CvArr)this.polygon, (opencv_core.CvSlice)opencv_core.CV_WHOLE_SEQ, (int)-1));
    }

    public int getPerimeter() {
        return (int)opencv_imgproc.cvArcLength((Pointer)this.polygon, (opencv_core.CvSlice)opencv_core.CV_WHOLE_SEQ, (int)-1);
    }

    public void dispose() {
        this.polygon.deallocate();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

