// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

#include "frc/commands/WaitCommand.h"

#include <fmt/format.h>

using namespace frc;

WaitCommand::WaitCommand(units::second_t timeout)
    : TimedCommand(fmt::format("Wait({})", timeout.value()), timeout) {}

WaitCommand::WaitCommand(std::string_view name, units::second_t timeout)
    : TimedCommand(name, timeout) {}
