// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

#include "commands/TurnToAngle.h"

#include <frc/controller/PIDController.h>

using namespace DriveConstants;

TurnToAngle::TurnToAngle(units::degree_t target, DriveSubsystem* drive)
    : CommandHelper(
          frc2::PIDController(kTurnP, kTurnI, kTurnD),
          // Close loop on heading
          [drive] { return drive->GetHeading().value(); },
          // Set reference to target
          target.value(),
          // Pipe output to turn robot
          [drive](double output) { drive->ArcadeDrive(0, output); },
          // Require the drive
          {drive}) {
  // Set the controller to be continuous (because it is an angle controller)
  m_controller.EnableContinuousInput(-180, 180);
  // Set the controller tolerance - the delta tolerance ensures the robot is
  // stationary at the setpoint before it is considered as having reached the
  // reference
  m_controller.SetTolerance(kTurnTolerance.value(), kTurnRateTolerance.value());

  AddRequirements({drive});
}

bool TurnToAngle::IsFinished() {
  return GetController().AtSetpoint();
}
